/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ConfigurationManager;
import com.zabbix.gateway.GeneralInformation;
import com.zabbix.gateway.SocketProcessor;
import com.zabbix.gateway.ZabbixException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGateway {
    private static final Logger logger = LoggerFactory.getLogger(JavaGateway.class);
    public static final Map<String, Long> iterativeObjects = Collections.synchronizedMap(new HashMap());

    public static void main(String[] stringArray) {
        if (1 == stringArray.length && (stringArray[0].equals("-V") || stringArray[0].equals("--version"))) {
            GeneralInformation.printVersion();
            System.exit(0);
        } else if (0 != stringArray.length) {
            System.out.println("unsupported command line options");
            System.exit(1);
        }
        logger.info("Zabbix Java Gateway {} (revision {}) has started", (Object)"7.2.12", (Object)"13e830929ce");
        Thread thread = new Thread(){

            @Override
            public void run() {
                logger.info("Zabbix Java Gateway {} (revision {}) has stopped", (Object)"7.2.12", (Object)"13e830929ce");
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        try {
            ConfigurationManager.parseConfiguration();
            InetAddress inetAddress = (InetAddress)ConfigurationManager.getParameter("listenIP").getValue();
            int n = ConfigurationManager.getIntegerParameterValue("listenPort");
            ServerSocket serverSocket = new ServerSocket(n, 0, inetAddress);
            serverSocket.setReuseAddress(true);
            logger.info("listening on {}:{}", (Object)serverSocket.getInetAddress(), (Object)serverSocket.getLocalPort());
            int n2 = ConfigurationManager.getIntegerParameterValue("startPollers");
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(n2), new ThreadPoolExecutor.CallerRunsPolicy());
            logger.debug("created a thread pool of {} pollers", (Object)n2);
            while (true) {
                threadPoolExecutor.execute(new SocketProcessor(serverSocket.accept()));
            }
        }
        catch (Exception exception) {
            logger.error("caught fatal exception: {}", (Object)ZabbixException.getRootCauseMessage(exception));
            logger.debug("error caused by", (Throwable)exception);
            return;
        }
    }
}

