/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.HelperFunctionChest;
import com.zabbix.gateway.ItemChecker;
import com.zabbix.gateway.JavaGateway;
import com.zabbix.gateway.ZabbixException;
import com.zabbix.gateway.ZabbixItem;
import com.zabbix.gateway.ZabbixJMXConnectorFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMXItemChecker
extends ItemChecker {
    private static final Logger logger = LoggerFactory.getLogger(JMXItemChecker.class);
    private JMXServiceURL url;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private String username;
    private String password;
    private String jmx_endpoint;
    private static HashMap<String, Boolean> useRMISSLforURLHintCache = new HashMap();

    JMXItemChecker(JSONObject jSONObject) throws ZabbixException {
        super(jSONObject);
        try {
            this.jmx_endpoint = jSONObject.getString("jmx_endpoint");
        }
        catch (Exception exception) {
            throw new ZabbixException(exception);
        }
        try {
            this.url = new JMXServiceURL(this.jmx_endpoint);
            this.jmxc = null;
            this.mbsc = null;
            this.username = jSONObject.optString("username", null);
            this.password = jSONObject.optString("password", null);
        }
        catch (Exception exception) {
            throw new ZabbixException("%s: %s", exception, this.jmx_endpoint);
        }
    }

    @Override
    JSONArray getValues() throws ZabbixException {
        JSONArray jSONArray = new JSONArray();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (null != this.username && null != this.password) {
                hashMap.put("jmx.remote.credentials", new String[]{this.username, this.password});
            }
            if (!useRMISSLforURLHintCache.containsKey(this.url.getURLPath()) || !useRMISSLforURLHintCache.get(this.url.getURLPath()).booleanValue()) {
                try {
                    this.jmxc = ZabbixJMXConnectorFactory.connect(this.url, hashMap);
                    useRMISSLforURLHintCache.put(this.url.getURLPath(), false);
                }
                catch (IOException iOException) {
                    hashMap.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
                    this.jmxc = ZabbixJMXConnectorFactory.connect(this.url, hashMap);
                    useRMISSLforURLHintCache.put(this.url.getURLPath(), true);
                }
            } else {
                try {
                    hashMap.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
                    this.jmxc = ZabbixJMXConnectorFactory.connect(this.url, hashMap);
                    useRMISSLforURLHintCache.put(this.url.getURLPath(), true);
                }
                catch (IOException iOException) {
                    hashMap.remove("com.sun.jndi.rmi.factory.socket");
                    this.jmxc = ZabbixJMXConnectorFactory.connect(this.url, hashMap);
                    useRMISSLforURLHintCache.put(this.url.getURLPath(), false);
                }
            }
            this.mbsc = this.jmxc.getMBeanServerConnection();
            logger.debug("using RMI SSL for " + this.url.getURLPath() + ": " + useRMISSLforURLHintCache.get(this.url.getURLPath()));
            for (String string : this.keys) {
                jSONArray.put((Object)this.getJSONValue(string));
            }
        }
        catch (SecurityException securityException) {
            JSONObject jSONObject = new JSONObject();
            logger.warn("cannot process keys '{}': {}: {}", new Object[]{this.keys, ZabbixException.getRootCauseMessage(securityException), this.url});
            logger.debug("error caused by", (Throwable)securityException);
            try {
                jSONObject.put("error", (Object)ZabbixException.getRootCauseMessage(securityException));
            }
            catch (JSONException jSONException) {
                Object[] objectArray = new Object[]{"error", securityException.getMessage(), ZabbixException.getRootCauseMessage(jSONException)};
                logger.warn("cannot add JSON attribute '{}' with message '{}': {}", objectArray);
                logger.debug("error caused by", (Throwable)jSONException);
            }
            for (int i = 0; i < this.keys.size(); ++i) {
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (Exception exception) {
            throw new ZabbixException("%s: %s", ZabbixException.getRootCauseMessage(exception), this.url);
        }
        finally {
            try {
                if (null != this.jmxc) {
                    this.jmxc.close();
                }
            }
            catch (IOException iOException) {}
            this.jmxc = null;
            this.mbsc = null;
        }
        return jSONArray;
    }

    @Override
    protected String getStringValue(String string) throws Exception {
        ZabbixItem zabbixItem = new ZabbixItem(string);
        int n = zabbixItem.getArgumentCount();
        if (zabbixItem.getKeyId().equals("jmx")) {
            String string2;
            String string3;
            if (2 != n && 3 != n) {
                throw new ZabbixException("required key format: jmx[<mbean name>,<attribute name>,<unique short description>]");
            }
            ObjectName objectName = new ObjectName(zabbixItem.getArgument(1));
            String string4 = zabbixItem.getArgument(2);
            int n2 = HelperFunctionChest.separatorIndex(string4);
            if (-1 != n2) {
                string3 = string4.substring(0, n2);
                string2 = string4.substring(n2 + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            string3 = HelperFunctionChest.unescapeUserInput(string3);
            logger.debug("obtaining [{}] [{}] [{}]", new Object[]{objectName, string3, string2});
            try {
                Object object = this.mbsc.getAttribute(objectName, string3);
                return this.getValueByMetric(object, string2);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new ZabbixException("Attribute not found: %s", ZabbixException.getRootCauseMessage(attributeNotFoundException));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new ZabbixException("Object or attribute not found: %s", ZabbixException.getRootCauseMessage(instanceNotFoundException));
            }
        }
        if (zabbixItem.getKeyId().equals("jmx.discovery") || zabbixItem.getKeyId().equals("jmx.get")) {
            String string5;
            ObjectName objectName;
            if (3 < n) {
                throw new ZabbixException("required key format: " + zabbixItem.getKeyId() + "[<discovery mode>,<object name>,<unique short description>]");
            }
            try {
                objectName = 2 <= n ? new ObjectName(zabbixItem.getArgument(2)) : null;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new ZabbixException("invalid object name format: " + zabbixItem.getArgument(2));
            }
            boolean bl = zabbixItem.getKeyId().equals("jmx.discovery");
            JSONArray jSONArray = new JSONArray();
            DiscoveryMode discoveryMode = DiscoveryMode.ATTRIBUTES;
            if (0 < n) {
                string5 = zabbixItem.getArgument(1);
                if (string5.equals("beans")) {
                    discoveryMode = DiscoveryMode.BEANS;
                } else if (!string5.equals("attributes")) {
                    throw new ZabbixException("invalid discovery mode: " + string5);
                }
            }
            switch (discoveryMode) {
                case ATTRIBUTES: {
                    this.discoverAttributes(jSONArray, objectName, bl);
                    break;
                }
                case BEANS: {
                    this.discoverBeans(jSONArray, objectName, bl);
                }
            }
            if (bl) {
                string5 = new JSONObject();
                string5.put("data", (Object)jSONArray);
                return string5.toString();
            }
            return jSONArray.toString();
        }
        throw new ZabbixException("key ID '%s' is not supported", zabbixItem.getKeyId());
    }

    private String getValueByMetric(Object object, String string) throws Exception {
        if (null == object) {
            throw new ZabbixException("data object is null");
        }
        logger.trace("drilling down the {} to find metric '{}'", object, (Object)string);
        while (!string.equals("")) {
            Object object2;
            String string2;
            int n = HelperFunctionChest.separatorIndex(string);
            if (-1 != n) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
                string = "";
            }
            string2 = HelperFunctionChest.unescapeUserInput(string2);
            if (object instanceof CompositeData) {
                logger.trace("[{}] contains composite data", (Object)string);
                object2 = (CompositeData)object;
                object = object2.get(string2);
                continue;
            }
            if (object instanceof TabularData) {
                logger.trace("[{}] contains tabular data", (Object)string);
                object2 = (TabularData)object;
                object = object2.get(new String[]{string2});
                continue;
            }
            throw new ZabbixException("unsupported data object type along the path: %s", object.getClass());
        }
        try {
            if (this.isPrimitiveMetricType(object)) {
                logger.trace("found: {}", (Object)object.toString());
                return object.toString();
            }
            throw new NoSuchMethodException();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ZabbixException("The value cannot be converted to string.");
        }
    }

    private JSONArray getTabularData(TabularData tabularData) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : tabularData.values()) {
            JSONObject jSONObject = this.getCompositeDataValues((CompositeData)obj);
            if (jSONObject.length() <= 0) continue;
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private JSONObject getCompositeDataValues(CompositeData compositeData) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : compositeData.getCompositeType().keySet()) {
            Object object = compositeData.get(string);
            if (object == null) {
                jSONObject.put(string, JSONObject.NULL);
                continue;
            }
            if (object.getClass().isArray()) {
                logger.trace("found attribute of a known, unsupported type: {}", object.getClass());
                continue;
            }
            if (object instanceof TabularData) {
                jSONObject.put(string, (Object)this.getTabularData((TabularData)object));
                continue;
            }
            if (object instanceof CompositeData) {
                jSONObject.put(string, (Object)this.getCompositeDataValues((CompositeData)object));
                continue;
            }
            jSONObject.put(string, object);
        }
        return jSONObject;
    }

    private void discoverAttributes(JSONArray jSONArray, ObjectName objectName, boolean bl) throws Exception {
        for (ObjectName objectName2 : this.mbsc.queryNames(objectName, null)) {
            AttributeList attributeList;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.mbsc.getMBeanInfo(objectName2).getAttributes();
            if (0 == mBeanAttributeInfoArray.length) {
                logger.trace("object has no attributes");
                return;
            }
            String[] stringArray = this.getAttributeNames(mBeanAttributeInfoArray);
            String string = this.jmx_endpoint + "#" + objectName2;
            Long l = JavaGateway.iterativeObjects.get(string);
            long l2 = System.currentTimeMillis();
            if (null != l && l2 <= l) {
                attributeList = this.getAttributesIterative(objectName2, stringArray);
            } else {
                try {
                    attributeList = this.getAttributesBulk(objectName2, stringArray);
                    if (null != l) {
                        JavaGateway.iterativeObjects.remove(string);
                    }
                }
                catch (Exception exception) {
                    attributeList = this.getAttributesIterative(objectName2, stringArray);
                    JavaGateway.iterativeObjects.put(string, l2 + 86400000L);
                }
            }
            if (attributeList.isEmpty()) {
                logger.warn("cannot process any attribute for object '{}'", (Object)objectName2);
                return;
            }
            for (Attribute attribute : attributeList.asList()) {
                hashMap.put(attribute.getName(), attribute.getValue());
            }
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                logger.trace("discovered attribute '{}'", (Object)mBeanAttributeInfo.getName());
                Object v = hashMap.get(mBeanAttributeInfo.getName());
                if (null == v) {
                    logger.trace("cannot retrieve attribute value, skipping");
                    continue;
                }
                try {
                    String string2;
                    String string3 = string2 = mBeanAttributeInfo.getName().equals(mBeanAttributeInfo.getDescription()) ? null : mBeanAttributeInfo.getDescription();
                    if (v instanceof TabularData) {
                        logger.trace("looking for attributes of tabular types");
                        this.formatPrimitiveTypeResult(jSONArray, objectName2, string2, mBeanAttributeInfo.getName(), v, bl, this.getTabularData((TabularData)v));
                        continue;
                    }
                    logger.trace("looking for attributes of primitive types");
                    this.getAttributeFields(jSONArray, objectName2, string2, mBeanAttributeInfo.getName(), v, bl);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{objectName2, mBeanAttributeInfo.getName(), ZabbixException.getRootCauseMessage(exception)};
                    logger.warn("attribute processing '{},{}' failed: {}", objectArray);
                    logger.debug("error caused by", (Throwable)exception);
                }
            }
        }
    }

    private String[] getAttributeNames(MBeanAttributeInfo[] mBeanAttributeInfoArray) {
        int n = 0;
        String[] stringArray = new String[mBeanAttributeInfoArray.length];
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
            if (!mBeanAttributeInfo.isReadable()) {
                logger.trace("attribute '{}' not readable, skipping", (Object)mBeanAttributeInfo.getName());
                continue;
            }
            stringArray[n++] = mBeanAttributeInfo.getName();
        }
        return stringArray;
    }

    private AttributeList getAttributesBulk(ObjectName objectName, String[] stringArray) throws Exception {
        return this.mbsc.getAttributes(objectName, stringArray);
    }

    private AttributeList getAttributesIterative(ObjectName objectName, String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        for (String string : stringArray) {
            try {
                Object object = this.mbsc.getAttribute(objectName, string);
                attributeList.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{objectName, string, ZabbixException.getRootCauseMessage(exception)};
                logger.warn("attribute processing '{},{}' failed: {}", objectArray);
                logger.debug("error caused by", (Throwable)exception);
            }
        }
        return attributeList;
    }

    private void discoverBeans(JSONArray jSONArray, ObjectName objectName, boolean bl) throws Exception {
        for (ObjectName objectName2 : this.mbsc.queryNames(objectName, null)) {
            logger.trace("discovered bean '{}'", (Object)objectName2);
            try {
                String string;
                JSONObject jSONObject;
                JSONObject jSONObject2 = new JSONObject();
                if (bl) {
                    jSONObject = new HashSet();
                    jSONObject2.put("{#JMXOBJ}", (Object)objectName2);
                    jSONObject2.put("{#JMXDOMAIN}", (Object)objectName2.getDomain());
                    jSONObject.add("OBJ");
                    jSONObject.add("DOMAIN");
                    for (Map.Entry<String, String> entry : objectName2.getKeyPropertyList().entrySet()) {
                        string = entry.getKey().toUpperCase();
                        if (string.matches("^[A-Z0-9_\\.]+$") && !jSONObject.contains(string)) {
                            jSONObject2.put("{#JMX" + string + "}", (Object)entry.getValue());
                            jSONObject.add(string);
                            continue;
                        }
                        logger.trace("bean '{}' property '{}' was ignored", (Object)objectName2, (Object)entry.getKey());
                    }
                } else {
                    jSONObject = new JSONObject();
                    jSONObject2.put("object", (Object)objectName2);
                    jSONObject2.put("domain", (Object)objectName2.getDomain());
                    for (Map.Entry<String, String> entry : objectName2.getKeyPropertyList().entrySet()) {
                        string = entry.getKey();
                        jSONObject.put(string, (Object)entry.getValue());
                    }
                    jSONObject2.put("properties", (Object)jSONObject);
                }
                jSONArray.put((Object)jSONObject2);
            }
            catch (Exception exception) {
                logger.warn("bean processing '{}' failed: {}", (Object)objectName2, (Object)ZabbixException.getRootCauseMessage(exception));
                logger.debug("error caused by", (Throwable)exception);
            }
        }
    }

    private void getAttributeFields(JSONArray jSONArray, ObjectName objectName, String string, String string2, Object object, boolean bl) throws NoSuchMethodException, JSONException {
        if (null == object || this.isPrimitiveMetricType(object)) {
            logger.trace("found attribute of a primitive type: {}", null == object ? "null" : object.getClass());
            this.formatPrimitiveTypeResult(jSONArray, objectName, string, string2, object, bl, object);
        } else if (object instanceof CompositeData) {
            logger.trace("found attribute of a composite type: {}", object.getClass());
            CompositeData compositeData = (CompositeData)object;
            for (String string3 : compositeData.getCompositeType().keySet()) {
                logger.trace("drilling down with attribute path '{}'", (Object)(string2 + "." + string3));
                this.getAttributeFields(jSONArray, objectName, compositeData.getCompositeType().getDescription(string3), string2 + "." + string3, compositeData.get(string3), bl);
            }
        } else if (object.getClass().isArray()) {
            logger.trace("found attribute of a known, unsupported type: {}", object.getClass());
        } else {
            logger.trace("found attribute of an unknown, unsupported type: {}", object.getClass());
        }
    }

    private void formatPrimitiveTypeResult(JSONArray jSONArray, ObjectName objectName, String string, String string2, Object object, boolean bl, Object object2) throws JSONException {
        Object object3;
        JSONObject jSONObject = new JSONObject();
        String string3 = null == string ? objectName + "," + string2 : string;
        Object object4 = null == object ? JSONObject.NULL : object.getClass().getName();
        Object object5 = object3 = null == object2 ? JSONObject.NULL : object2.toString();
        if (bl) {
            jSONObject.put("{#JMXDESC}", (Object)string3);
            jSONObject.put("{#JMXOBJ}", (Object)objectName);
            jSONObject.put("{#JMXATTR}", (Object)string2);
            jSONObject.put("{#JMXTYPE}", object4);
            jSONObject.put("{#JMXVALUE}", object3);
        } else {
            jSONObject.put("name", (Object)string2);
            jSONObject.put("object", (Object)objectName);
            jSONObject.put("description", (Object)string3);
            jSONObject.put("type", object4);
            jSONObject.put("value", object3);
        }
        jSONArray.put((Object)jSONObject);
    }

    private boolean isPrimitiveMetricType(Object object) throws NoSuchMethodException {
        Class[] classArray = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, BigDecimal.class, BigInteger.class, Date.class, ObjectName.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class};
        return HelperFunctionChest.arrayContains(classArray, object.getClass()) || !(object instanceof CompositeData) && !(object instanceof TabularDataSupport) && object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
    }

    public void cleanUseRMISSLforURLHintCache() {
        int n = useRMISSLforURLHintCache.size();
        useRMISSLforURLHintCache.clear();
        logger.debug("Finished cleanup of RMI SSL hint cache. " + n + " entries removed.");
    }

    private static enum DiscoveryMode {
        ATTRIBUTES,
        BEANS;

    }
}

