/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ZabbixException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ItemChecker {
    private static final Logger logger = LoggerFactory.getLogger(ItemChecker.class);
    static final String JSON_TAG_DATA = "data";
    static final String JSON_TAG_ERROR = "error";
    static final String JSON_TAG_KEYS = "keys";
    static final String JSON_TAG_PASSWORD = "password";
    static final String JSON_TAG_REQUEST = "request";
    static final String JSON_TAG_RESPONSE = "response";
    static final String JSON_TAG_USERNAME = "username";
    static final String JSON_TAG_VALUE = "value";
    static final String JSON_TAG_JMX_ENDPOINT = "jmx_endpoint";
    static final String JSON_REQUEST_INTERNAL = "java gateway internal";
    static final String JSON_REQUEST_JMX = "java gateway jmx";
    static final String JSON_RESPONSE_FAILED = "failed";
    static final String JSON_RESPONSE_SUCCESS = "success";
    protected JSONObject request;
    protected ArrayList<String> keys;

    protected ItemChecker(JSONObject jSONObject) throws ZabbixException {
        this.request = jSONObject;
        try {
            JSONArray jSONArray = jSONObject.getJSONArray(JSON_TAG_KEYS);
            this.keys = new ArrayList();
            for (int i = 0; i < jSONArray.length(); ++i) {
                this.keys.add(jSONArray.getString(i));
            }
        }
        catch (Exception exception) {
            throw new ZabbixException(exception);
        }
    }

    protected final void finalize() throws Throwable {
    }

    JSONArray getValues() throws ZabbixException {
        JSONArray jSONArray = new JSONArray();
        for (String string : this.keys) {
            jSONArray.put((Object)this.getJSONValue(string));
        }
        return jSONArray;
    }

    String getFirstKey() {
        return 0 == this.keys.size() ? null : this.keys.get(0);
    }

    protected final JSONObject getJSONValue(String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            logger.debug("getting value for item '{}'", (Object)string);
            String string2 = this.getStringValue(string);
            logger.debug("received value '{}' for item '{}'", (Object)string2, (Object)string);
            jSONObject.put(JSON_TAG_VALUE, (Object)string2);
        }
        catch (Exception exception) {
            try {
                logger.debug("caught exception for item '{}'", (Object)string, (Object)exception);
                jSONObject.put(JSON_TAG_ERROR, (Object)ZabbixException.getRootCauseMessage(exception));
            }
            catch (JSONException jSONException) {
                Object[] objectArray = new Object[]{JSON_TAG_ERROR, exception.getMessage(), ZabbixException.getRootCauseMessage(jSONException)};
                logger.warn("cannot add JSON attribute '{}' with message '{}': {}", objectArray);
                logger.debug("error caused by", (Throwable)jSONException);
            }
        }
        return jSONObject;
    }

    protected abstract String getStringValue(String var1) throws Exception;
}

